#!/bin/sh

## This is a test bash script to run MMC
## It assumes that the scripts are in a subfolder of the data input, but it can be anywhere
## ALL scripts associated with MMC need to be in the same folder
## But you can invoke the script from anywhere and it should still run

## Input data
INDIR=$(pwd)
DATAIN=$INDIR/test_data.csv

## Variables
SIGMA_LOW=0.05
SIGMA_HIGH=0.50
SIGMA_NUM=451
HEATMAP_STYLE=matplotlib
CORR_TYPE=pearson

## Ouputs
OUTDIR=$(pwd)
DATAOUT=$OUTDIR/test_data_output.csv
HEATMAP_UNSORT=test.unsorted.heatmap.png
HEATMAP_SORT=test.sorted.heatmap.png
HEATMAP_SMOOTH=test.smoothed.heatmap.png

## Location of MMC script
MMCDIR=./mmc

## There are other options that MMC has that I haven't used, but that the user may want to eventually
## --verbose                                    gives you a verbose output to the console
## --sigma-low $VAR                             specify low sigma threshold (default is 0.05)
## --sigma-high $VAR                            specify high sigma threshold (default is 0.50)
## --sigma-num $VAR                             Number of sigma values to search (default is 451)
## --heatmap-style {seaborn,matplotlib,rdata}   use this to specify which package to use to generate heatmaps
##                                              The default is matplotlib
## --correlation {pearson,jendall,spearman}     specify which correlation statistic to use.
##                                              Default is pearson

## Example of including all variables (default settings)
python ${MMCDIR}/run-mmc.py --csv-in ${DATAIN} \
                            --csv-out ${DATAOUT} \
                            --unsorted-heatmap ${HEATMAP_UNSORT} \
                            --sorted-heatmap ${HEATMAP_SORT} \
                            --smoothed-heatmap ${HEATMAP_SMOOTH} \
                            --sigma-low ${SIGMA_LOW} \
                            --sigma-high ${SIGMA_HIGH} \
                            --sigma-num ${SIGMA_NUM} \
                            --heatmap-style ${HEATMAP_STYLE} \
                            --correlation ${CORR_TYPE}



