"""
Tests.

"""
from __future__ import print_function, division, absolute_import

import numpy as np
from numpy.testing import assert_allclose

from libmmc import expansion, modularity_matrix, modularity


def test_wikipedia_modularity_fig2():
    # Check the modularity of the example in figure 2 on the wikipedia page.
    p = 10
    edges = ((0, 1), (1, 2), (2, 0), (0, 3), (3, 4), (4, 5), (5, 6), (6, 4),
             (3, 7), (7, 8), (8, 9), (9, 7))
    A = np.zeros((p, p))
    for a, b in edges:
        A[a, b] = 1
        A[b, a] = 1
    d = A.sum()
    B = modularity_matrix(A)
    v = [0, 0, 0, 0, 1, 1, 1, 2, 2, 2]
    assert_allclose(modularity(B, d, v), 0.489583333333)
